package gov.va.vinci.dart.biz;

import java.util.Date;
import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestRequest extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		ResearchStudy activity = ResearchStudy.findById(1);
		Assert.assertNotNull(activity);
		Assert.assertTrue(activity.getId() > 0);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 1", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		Request req2 = Request.findById(req.getId());
		Assert.assertNotNull(req2);
		Assert.assertEquals(req2, req);
	}
	
	@Test
	public void testTwo() throws Exception {
		Person pers = Person.findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);

		ResearchStudy activity = ResearchStudy.findById(1);
		Assert.assertNotNull(activity);
		Assert.assertTrue(activity.getId() > 0);
		
		// create request 1 so we'll have something to work with
		DartRequest req = DartRequest.create("test request 2", new Date(), new Date(), pers, activity, "DNS");

		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		// add a participant to the request
		Participant participant = Participant.create(pers, req, pers.getLocation(), true, true, true);
		req.getParticipants().add(participant);
		
		Request req2 = Request.findById(req.getId());
		Assert.assertNotNull(req2);
		Assert.assertEquals(req2, req);
		
		String trackingNumber = req.getTrackingNumber();
		Assert.assertNotNull(trackingNumber);
		Assert.assertTrue(trackingNumber.length() > 0);
		
		List<RequestSummary> rList = Request.listByTrackingNumber(trackingNumber);
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = Request.listAllRequestSummary();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = Request.listAllRequestSummaryWithoutContactName();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = Request.listAllButInitiated();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = Request.listAllButInitiatedWithoutContactName();
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);

		rList = Request.listAllUserReviewable(pers.getId());
		Assert.assertNotNull(rList);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		rList = Request.listAllGroupReviewable(pers.getGroups().iterator().next().getName());
		Assert.assertNotNull(rList);

		List<RequestLocationDocumentSummary> rldsList = Request.listRequestLocationDocumentSummaryByReviewer(req.getId(), pers.getName());
		Assert.assertNotNull(rldsList);

		List<RequestParticipantDocumentSummary> rpdsList = Request.listRequestParticipantDocumentSummaryByReviewer(req.getId(), pers.getName());
		Assert.assertNotNull(rpdsList);

	}

    @Test
    public void TestThree() throws Exception {
        Person person = Person.findById(1006);
        Assert.assertNotNull(person);
        Assert.assertTrue(person.getId() > 0);

        ResearchStudy activity = ResearchStudy.findById(1);
        Assert.assertNotNull(activity);
        Assert.assertTrue(activity.getId() > 0);


        Request request = DartRequest.create("test request 3", new Date(), new Date(), person, activity, "DNS");
        Assert.assertNotNull(request);
        Assert.assertTrue(request.getId() > 0);

        Participant participant = Participant.create(person, request, person.getLocation(), true, true, true);
        Assert.assertNotNull(participant);
        Assert.assertTrue(participant.getId() > 0);
        request.getParticipants().add(participant);

        String trackingNumber = request.getTrackingNumber();
        Assert.assertNotNull(trackingNumber);
        Assert.assertTrue(trackingNumber.length() > 0);

        request.trackingNumber.concat(" (123456)");

        System.out.println(request.getTrackingNumber().toString());

        Object obj = request.generateAmendmentTrackingNumber(request);
        Assert.assertNotNull(obj);

        System.out.println(obj.toString());
    //        Assert.assertEquals(str,obj.toString());
    /*
            String str = "2011-01-014-D (20090917)";
    //        String str = "(20090917)";

            //String[] strParts = str.split("\\((.*?)\\)");

            String[] strParts = str.split("\\(");
            strParts[1] = strParts[1].substring(0,strParts[1].length()-1);



            Formatter fmt = new Formatter();
            // 1. trackingId 2. amendmentId 3. extraOldDartStuff
            fmt.format("%1$s-A%2$02d (%3$s)", strParts[0].trim(), 12, strParts[1].trim());

            System.out.println(fmt.toString());
            */
    }
}
